@echo off
setlocal EnableDelayedExpansion

set MARIADB_INIT_CNF=..\..\config\mariadb\init.cnf
set BASE_TOOLS=..\..\tools\windows
set "PROJECT_DIR=..\..\project\"

call :menu
goto :eof

:set_readonly_if_exists
echo.
if not exist "%MARIADB_INIT_CNF%" (
    echo [X] File does not exist: %MARIADB_INIT_CNF%
    goto :eof
)

attrib +r "%MARIADB_INIT_CNF%"
echo [OK] File is now read-only.
echo.
pause
goto :eof

:create_project_folder_ifnot_exists
echo.
set "TARGET_DIR=..\..\project"

if not exist "%TARGET_DIR%\" (
    echo [I] Folder "%TARGET_DIR%" does not exist. Creating it...
    mkdir "%TARGET_DIR%"
)
echo.
goto :eof

:clone_repo_with_git
    set "GIT_EXE=%~1"
    echo.
    call :create_project_folder_ifnot_exists
    echo [I] Cloning repository ...
    "%GIT_EXE%" clone https://github.com/onesaitplatform/onesaitplatform-cloud %PROJECT_DIR%
    exit /B

:clone_repository
echo.
where git >nul 2>&1
if errorlevel 1 (
    echo [X] Git is NOT installed. Trying to use Git under tools folder ...
    set "LOCAL_GIT=%BASE_TOOLS%\git\bin\git.exe"
    if exist "%LOCAL_GIT%" (
        echo [!] Using Local Git
        call :clone_repo_with_git "%LOCAL_GIT%"
    ) else (
        echo [X] Local git NOT found at "%LOCAL_GIT%"
        echo Please install system git or place git.exe under "%BASE_TOOLS%\git\bin\"
    )
) else (
    echo [I] Using System Git
    call :clone_repo_with_git git
)
echo.
pause
goto :eof

:menu
cls
echo ==========================================
echo           Windows Setup Menu
echo         Powered By Indra Company
echo ==========================================
echo 1) Check MariaDB init.cnf file and set read-only (required)
echo 2) Clone project from repository
echo 3) Exit
echo ------------------------------------------
choice /C 12345678 /N /M "Please select an option [1-8]: "
set "option=%errorlevel%"

if "%option%"=="1" (
    call :set_readonly_if_exists
    goto menu
)
if "%option%"=="2" (
    call :clone_repository
    goto menu
)
if "%option%"=="3" (
    echo Exiting setup script. Goodbye!
    exit /b 0
)

echo Invalid option, please try again.
timeout /t 2 >nul
goto menu
