#!/bin/bash
MARIADB_INIT_CNF="../../config/mariadb/init.cnf"
BASE_TOOLS="../../tools/linux"
PROJECT_DIR="../../project/"

check_file_permissions() {
    local file="$MARIADB_INIT_CNF"
    local expected_perms="644"

    if [ ! -e "$file" ]; then
        echo "[X] File does not exist: $file"
        return 2
    fi

    local perms
    perms=$(stat -c "%a" "$file")

    if [ "$perms" -eq "$expected_perms" ]; then
        echo "[OK] $file has correct permissions: $perms"
        return 0
    else
        echo "[X] $file has incorrect permissions: $perms (expected: $expected_perms)"
        return 1
    fi
}

set_permissions_and_check() {
    echo -e "\n[!] Setting permissions to $MARIADB_INIT_CNF ..."
    chmod 644 "$MARIADB_INIT_CNF"
    check_file_permissions
    echo
    read -rp "Press Enter to continue..."
}

clone_repo_with_git() {
  echo "[!] Cloning repository ... "
  local git_cmd="$1"
  shift
  "$git_cmd" clone https://github.com/onesaitplatform/onesaitplatform-cloud "$PROJECT_DIR" "$@"
}

clone_repository() {
  if command -v git &> /dev/null; then
    echo "[!] Using System Git"
    clone_repo_with_git "$(command -v git)"
  else
    echo "[X] Git is NOT installed. Trying to use Git under tools folder ..."
    local local_git="$BASE_TOOLS/git"
    if [ ! -x "$local_git" ]; then
      echo "[X] Git binary not found or not executable at $local_git"
      echo "Run the 'onesait-platform-env' container to initialize the tools"
      return 1
    fi
    echo "[!] Using Local Git"
    clone_repo_with_git "$local_git"
  fi
  read -rp "Press Enter to continue..."
}

while true; do
    clear
    echo "=========================================="
    echo "           Linux Setup Menu               "
    echo "        Powered By Indra Company          "
    echo "=========================================="
    echo "1) Set permissions on MariaDB init.cnf and verify (Required)"
    echo "2) Clone project from repository"
    echo "3) Exit"
    echo "------------------------------------------"
    read -rp "Please select an option [1-8]: " option

    case $option in
        1) set_permissions_and_check ;;
        2) clone_repository ;;
        3)
            echo -e "\nExiting setup script. Goodbye!\n"
            exit 0
            ;;
        *)
            echo -e "\nInvalid option, please try again."
            sleep 1.5
            ;;
    esac
done
