#!/bin/bash
echo "[!] Cleaning linux tools directory ... "
rm -rf /opt/maven
rm -rf /opt/jdk-*
rm -rf /opt/git
rm -rf /opt/mavend

echo "[!] Copying files ... "
cp -rf /usr/share/maven /opt/maven
cp -rf /usr/share/maven-mvnd-1.0.2-linux-amd64/ /opt/mavend
cp -r /usr/lib/jvm/java-17-openjdk-amd64/ /opt/jdk-17/
cp -r /usr/lib/jvm/java-8-openjdk-amd64/ /opt/jdk-8/
cp -rf $(which git) /opt/git

export LD_LIBRARY_PATH=/opt/jdk/openjdk-17/lib/server:$LD_LIBRARY_PATH

copydash_dir="./tools/Dashboard"
echo "[!] Changing EOL of script located at $copydash_dir ..."
if [ ! -e "$copydash_dir" ]; then
    echo "[X] ERROR: Make sure that the project is correctly cloned inside the project folder."
    exit 2
else
    sed -i 's/\r$//' "$copydash_dir/copydash.sh"
fi

echo "[OK] Setup complete!"
echo "============================================================="
echo "Now you can enter to the container for the first build using: "
echo "docker exec -it <container_id|container_name> /bin/bash"
echo "and then run the alias 'mvndcinotest'"
echo "Enjoy it!"

exec "$@"